'use client'

import { ArrowLeftIcon } from "@radix-ui/react-icons"
import { Button } from "../ui/button"
import { useRouter } from "@/lib/navigation.router"

export function NavigationGoBack() {
    const router = useRouter()
    return (
        <Button 
            variant={"expandIcon"} 
            iconPlacement="left" 
            Icon={ArrowLeftIcon} 
            className="w-svw max-w-96 bg-primary text-primary-foreground"
            onClick={router.back}
        >
            Let&apos;s go back
        </Button>
    )
}